	.include	'eq.s'
	.include	'externs.s'

	.text
initonce::
;do this stuff once at the beginning of the program
	move.l	#$00070007,G_END		;don't need to swap for GPU
	move.w	#$35cc,MEMCON2			;Do the old endian thing

	move.w	#$0100,JOYIN			;set bit 8 to cancel mute

	move.b	#0,pal_ntsc			;set flag to NTSC (will need to check for this somehow)

;copy the adjblack .GAS code into the GPU
;it will remain there because dejag and build don't use that part of GPU ram
	move.l	#$00000008,G_CTRL		;stop the GPU
	move.l	#adblack,a0			;starting address of adjblack.bin
	move.l	(a0)+,a1				;GPU ram address
	move.l	(a0)+,d0				;size of code in bytes
	asr.l	#2,d0
	subq.l	#1,d0				;subtract 1 for loop counter
.10:	move.l	(a0)+,(a1)+
	dbra		d0,.10

	move.w	#5,d0				;copy the default seeds into ram
	lea		seedinit,a0
	lea		seed,a1
.20:	move.l	(a0)+,(a1)+
	dbra		d0,.20
	clr.b	intcount

	bsr		load_dta				;load misc object data that will remain in ram
	lea		palette,a0			;get address of palette
	bsr		set_palette			;copy palette into

	bsr		ob_heads				;copy object headers into ram

	bsr		ld_build				;load GPU code to build object list
	move.l	#scrcover,FIRSTOBJ_ADR	;address of first object header
	move.l	#1,TOTOBJS_ADR			;total objects in list
	bsr		do_build				;build packed object list
	bsr		copy_olist
	move.l	#olist,d0				;get address of start of object list
	swap		d0
	move.l	d0,OLP

	bsr		VideoIni				;init video stuff
	bsr		IntInit

	move.w	#$4C7,VMODE			;turn on display, 16 bit RGB

	move.l	#dehuff,Dehuff_Adr		;set the pointer to dehuff.abs table

	clr.w	sampnum				;sample number played by * key on controller 2
	bsr		ld_decmp
	move.l	#q65,a3				;starting address of default zd_table
	bsr		load_dq
	bsr		loadgrph				;load player ships, shields, station

	bsr		ld_build				;load GPU code to build object list so clearscr will work at title screen

	move.b	#$FF,gamemode			;make sure title screen gets loaded the first time

	rts

ld_decmp::
;copy the decompression .GAS code into the GPU
	move.b	#DECOMPCODE,gpucode
	move.l	#$00000008,G_CTRL		;stop the GPU
	move.l	#dejagst,a0			;starting address of dejag.bin
	move.l	(a0)+,a1				;GPU ram address (should be G_RAM)
	move.l	(a0)+,d0				;size of code in bytes
	asr.l	#2,d0				;convert bytes to longs
	subq.l	#1,d0				;subtract 1 for loop counter
.20:	move.l	(a0)+,(a1)+
	dbra		d0,.20
	rts

ld_build::
;copy the object list builder .GAS code into the GPU
	move.b	#BUILDCODE,gpucode
	move.l	#$00000008,G_CTRL		;stop the GPU
	move.l	#build,a0				;starting address of olist.bin
	move.l	(a0)+,a1				;GPU ram address (should be GPU_RAM)
	move.l	(a0)+,d0				;size of code in bytes
	asr.l	#2,d0
	subq.l	#1,d0				;subtract 1 for loop counter
.20:	move.l	(a0)+,(a1)+
	dbra		d0,.20
	rts

ld_bldsc::
;copy the object list builder for scaled objects into the GPU
	move.b	#BUILDCODE,gpucode
	move.l	#$00000008,G_CTRL		;stop the GPU
	move.l	#buildsc,a0			;starting address of olistscl.bin
	move.l	(a0)+,a1				;GPU ram address (should be GPU_RAM)
	move.l	(a0)+,d0				;size of code in bytes
	asr.l	#2,d0
	subq.l	#1,d0				;subtract 1 for loop counter
.20:	move.l	(a0)+,(a1)+
	dbra		d0,.20
	rts

ld_uncmp::
;copy the uncomp .GAS code into the GPU
	move.l	#$00000008,G_CTRL		;stop the GPU
	move.l	#uncomp,a0			;starting address of uncomp.bin
	move.l	(a0)+,a1				;GPU ram address
	move.l	(a0)+,d0				;size of code in bytes
	asr.l	#2,d0				;convert bytes to longs
	subq.l	#1,d0				;subtract 1 for loop counter
.20:	move.l	(a0)+,(a1)+
	dbra		d0,.20
	rts

load_dq::
;load the decompression table into GPU ram
;A3 is the address of the table
	move.l	#$00000008,G_CTRL		;stop the GPU
	move.l	a3,A2_BASE					;source address
	move.l	#DQ_Adr,A1_BASE				;destination address in GPU ram
	move.l	#PITCH1|PIXEL32|WID80|XADDPHR,A1_FLAGS	;destination
	move.l	#PITCH1|PIXEL32|WID80|XADDPHR,A2_FLAGS	;source
	move.l	#0,A2_PIXEL					;start at 0,0 of source image
	move.l	#0,A1_PIXEL					;Y,X position to write data in destination area
	move.l	#$00010050,B_COUNT				;copy 320 bytes or 80 longs
	move.l	#$0001FFB0,A1_STEP				;1 in Y step size, negative width in X step size
	move.l	#UPDA1|SRCEN|LFU_A|LFU_AN,B_CMD	;turn on blitter
	rts

decomp::
	move.l	#G_RAM,G_PC			;set program counter
	move.l	#$00000011,G_CTRL		;start GPU
.20:	cmp.l	#dj_done,All_Done		;wait until decompression is finished
	bne		.20
	rts

ob_heads::
;copy object headers into ram
;adjust ypos of screen sized objects if NTSC
	lea		titlolst,a0
	lea		titlobjs,a1
	move.w	#(TITLE_OBJS*OBJ_SIZE/2)-1,d0
.05:	move.w	(a0)+,(a1)+
	dbra		d0,.05

	lea		congolst,a0
	lea		congobjs,a1
	move.w	#(CONGRATS_OBJS*OBJ_SIZE/2)-1,d0
.15:	move.w	(a0)+,(a1)+
	dbra		d0,.15

	lea		selolst,a0
	lea		selobjs,a1
	move.w	#(SEL_OBJS*OBJ_SIZE/2)-1,d0
.20:	move.w	(a0)+,(a1)+
	dbra		d0,.20

	lea		gameolst,a0
	lea		gameobjs,a1
	move.w	#(GAME_OBJS*OBJ_SIZE/2)-1,d0
.25:	move.w	(a0)+,(a1)+
	dbra		d0,.25

	lea		intolst,a0
	lea		intobjs,a1
	move.w	#(INTRO_OBJS*OBJ_SIZE/2)-1,d0
.30:	move.w	(a0)+,(a1)+
	dbra		d0,.30

	lea		scrcov,a0
	lea		scrcover,a1
	move.w	#(1*OBJ_SIZE/2)-1,d0
.35:	move.w	(a0)+,(a1)+
	dbra		d0,.35

	cmp.b	#1,pal_ntsc
	beq.b	.50
	move.w	#SCRN_TOP-64,scrcover+O_YPOS	;move up 32 lines
	move.w	#SCRN_TOP-64,t_scr+O_YPOS	;move up 32 lines
	move.w	#SCRN_TOP-64,selbackg+O_YPOS	;move up 32 lines
	move.w	#SCRN_TOP-64,introscr+O_YPOS	;move up 32 lines
	move.w	#SCRN_BOTTOM-576,congscr+O_YPOS
.50:
	rts

do_build::
;FIRSTOBJ_ADR = address of first object header
;TOTOBJS_ADR = total objects in list
	move.l	#olist,OLIST_ADR
	move.l	#olist_ram,OLISTR_ADR
	move.l	#BUILD_PRG,G_PC		;set program counter
	move.l	#$00000011,G_CTRL		;start GPU
.30:
	cmp.l	#1,DONE_ADR			;wait until build is finished
	bne.b	.30

	lea		olist_ram,a0
	lea		olist_bak,a1
	move.l	#209,d0			;copy 210 longs
.50:	move.l	(a0)+,(a1)+
	dbra		d0,.50
	rts

;copy 840 bytes
;	move.l	#PITCH1|PIXEL32|WID2|XADDPHR,d0
;	move.l	d0,A1_FLAGS					;destination
;	move.l	d0,A2_FLAGS					;source
;	move.l	#olist_bak,A1_BASE				;destination address
;	move.l	#olist_ram,A2_BASE				;source address
;	move.l	#0,A2_PIXEL					;start at 0,0 of source image
;	move.l	#0,A1_PIXEL					;Y,X position to write data in destination area
;	move.l	#$00690002,B_COUNT				;840 bytes, or 210 longs
;	move.l	#$0001FFFE,A1_STEP				;1 in Y step size, negative width in X step size
;	move.l	#UPDA1|SRCEN|LFU_A|LFU_AN,B_CMD	;turn on blitter
;	rts

copy_olist::
;	cmp.l	#BUILDING,DONE_ADR
	cmp.l	#1,DONE_ADR
	beq.b	.10				;wait until build is completed
	lea		olist_bak,a0		;use this when build is in progress
	bra.b	.20
.10:	lea		olist_ram,a0		;beginning of olist_ram
.20:	lea		olist,a1			;beginning of olist
	move.w	#209,d0			;copy 210 longs
.50:	move.l	(a0)+,(a1)+		;copy to olist
	dbra		d0,.50
	rts

VideoIni::
;   	move.w	#n_hp,HP
	move.w	#n_hbb,HBB
	move.w	#n_hbe,HBE
	move.w	#n_hs,HS
	move.w	#n_hvs,HVS
	move.w	#n_heq,HEQ
	move.w	#n_hde,HDE
	move.w	#n_hdb1,HDB1
	move.w	#n_hdb2,HDB2

	move.w	#n_vp,VP
	move.w	#n_vee,VEE
	move.w	#n_vbe,VBE
	move.w	#n_vdb,VDB
	move.w	#n_vde,VDE
	move.w	#n_vbb,VBB
	move.w	#n_veb,VEB
	move.w	#n_vs,VS
	move.w	#$0000,BG			;default background color (16 bit RGB or CRY color)
	move.l	#$00000000,BORD1	;default border color (green,red,unused,blue)
	rts

set_palette::
;A0 must be the address of the palette data
;palette data is 256 words of colors
	lea		CLUT,a1			;get address of color lookup table
	move.w	#255,d0			;number of colors to set
.10:	move.w	(a0)+,(a1)+		;put color value into color lookup table
	dbra		d0,.10			;continue through palette table
	rts

wait_int::
	move.b	framecnt,d0
.10:	cmp.b	intcount,d0
	bgt.b	.10
	clr.b	intcount
	rts
framecnt::	dc.b	1			;60 frames per second
	.even

LEVEL2	equ	4*$40
IntInit::
	move.l	#Frame,LEVEL2
	move.w	#n_vde|1,VI
	move.w	#1,INT1
	move.w	sr,d0
	and.w	#$f8ff,d0
	move.w	d0,sr
	rts
Frame::
	movem.l	d0-d6/a0-a6,-(sp)

	cmp.l	#1,DONE_ADR
	beq.b	.10				;wait until build is completed
	lea		olist_bak,a0		;use this when build is in progress
	bra.b	.20
.10:	lea		olist_ram,a0		;beginning of olist_ram
.20:	lea		olist,a1			;beginning of olist
.50:	move.l	(a0)+,d1
	move.l	d1,(a1)+			;copy to olist
	cmp.l	#4,d1
	bne.b	.50

	addq.b	#1,intcount
	move.w	#$101,INT1
	move.w	#0,INT2
	movem.l	(sp)+,d0-d6/a0-a6
	rte

random::
	move.l	d1,-(sp)
	move.l	seed+4,seed		;move seed 1 to seed 0
	move.l	seed+8,seed+4		;move seed 2 to seed 1
	move.l	seed+12,seed+8		;move seed 3 to seed 2
	move.l	seed+16,seed+12	;move seed 4 to seed 3
	move.l	seed+20,seed+16	;move seed 5 to seed 4
	move.l	seed,d0			;get seed 0
	move.l	seed+12, d1		;get seed 3
	addx.l	d1, d0			;add seed 0 to seed 3
	move.l	seed+20, d1		;get seed 5
	addx.l	d1, d0			;add seed 5 to seed 0 and seed 3
	move.l	d0, seed+20		;store result in seed 5
	move.l	seed, d0			;return new seed value in d0
	move.l	(sp)+, d1			;restore value that was in d1
	rts

seedinit::	dc.l $73510EA7,$495E98CF,$3279CF13,$11126C33,$73213445,$61AEAD73

